//FloorMountingPostHole.scad
//Module to make one mounting post hole;

//See also FloorMountingPost;
//That module creates the body of the 
//mounting post, but without a hole for 
//a screw to secure the UNO;
//This module provides the hole;
//In this version, the hole must extent 
//right thru the mounting post and the floor 
//on which it is supported;
//To achieve this, the holes need a 
//module of their own and can't be part of 
//the MountingPost module(s); 

//On output from this module, the mounting post 
//is centered about the Z axis and the XY plane;

//Any further adjustment of orientation
//and/or position must be done 
//by the calling module;

include <UNO_Dimensions.scad>;

module FloorMountingPostHole(ThisPhi)
{

echo("Begin FloorMountingPostHole");
    
cylinder(h=2*(PostUnoHeight +FloorZ),
    d=ThisPhi, center=true, $fn=32);
}

//
